

// BIRecurringInvoice.h
// BISubstrate
// 
// Copyright (c) 2008 Marketcircle Inc. All rights reserved.


#ifdef BILLINGS_PRO
#import "_BPRecurringInvoice.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIRecurringInvoice.h"
#endif
#import "BIAppVersioning.h"


@interface BIRecurringInvoice : BL_SUPER_CLASSNAME_MUNGE(RecurringInvoice)
{
}

- (NSNumber *)total;
- (NSString *)formattedTotal;

- (BOOL)shouldIncludeUnbilled;

- (BOOL)isNextSendDateOrPast;
- (void)calculateNextSendDate;

- (int)recurDayForMonth:(int)month year:(int)year;
- (BOOL)recurDayAtEndOfMonth;

- (int)recurDayInt;
- (void)setRecurDayInt:(int)anIntValue;
- (int)recurMonthsInt;
- (void)setRecurMonthsInt:(int)anIntValue;

- (NSNumberFormatter *)currencyFormatter;

@end
